/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.CustomRegisters;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.util.IPermission;

public class ItemScripted
extends Item
implements IPermission {
    public static Map<Integer, String> Resources = new HashMap<Integer, String>();

    public static ItemScriptedWrapper GetWrapper(ItemStack stack) {
        return (ItemScriptedWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
    }

    public ItemScripted() {
        this.setRegistryName("customnpcs", "scripted_item");
        this.func_77655_b("scripted_item");
        this.field_77777_bU = 1;
        this.func_77637_a(CustomRegisters.tab);
        this.func_77627_a(true);
    }

    public double getDurabilityForDisplay(@Nonnull ItemStack stack) {
        IItemStack istack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
        if (istack instanceof ItemScriptedWrapper) {
            return 1.0 - ((ItemScriptedWrapper)istack).durabilityValue;
        }
        return super.getDurabilityForDisplay(stack);
    }

    public int getItemStackLimit(@Nonnull ItemStack stack) {
        IItemStack istack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
        if (istack instanceof ItemScriptedWrapper) {
            return istack.getMaxStackSize();
        }
        return super.getItemStackLimit(stack);
    }

    public int getRGBDurabilityForDisplay(@Nonnull ItemStack stack) {
        IItemStack istack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
        if (!(istack instanceof ItemScriptedWrapper)) {
            return super.getRGBDurabilityForDisplay(stack);
        }
        int color = ((ItemScriptedWrapper)istack).durabilityColor;
        if (color >= 0) {
            return color;
        }
        return MathHelper.func_181758_c((float)((float)(Math.max(0.0, 1.0 - this.getDurabilityForDisplay(stack)) / 3.0)), (float)1.0f, (float)1.0f);
    }

    public boolean func_77644_a(@Nonnull ItemStack stack, @Nonnull EntityLivingBase target, @Nonnull EntityLivingBase attacker) {
        return true;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.ScriptItemDataGet || e == EnumPacketServer.ScriptItemDataSave;
    }

    public boolean showDurabilityBar(@Nonnull ItemStack stack) {
        IItemStack istack = Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack);
        if (istack instanceof ItemScriptedWrapper) {
            return ((ItemScriptedWrapper)istack).durabilityShow;
        }
        return super.showDurabilityBar(stack);
    }
}

